//=============================================================================
// UT_Invisibility.
//=============================================================================
class xmasInvisibility extends UT_Invisibility;

#exec AUDIO IMPORT FILE="Sounds\xmasInvis.WAV" NAME="xmasInvis"

state Activated
{
	function endstate()
	{
		local Inventory S;

		bActive = false;		
		PlaySound(DeActivateSound);

		Owner.SetDefaultDisplayProperties();
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			UT_Shieldbelt(S).MyEffect.bHidden = false;
	}

	function Activate()
	{
		bActive = true;
		SetOwnerDisplay();
	}

	function SetOwnerDisplay()
	{
		if ( !bActive )
			return;
		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent, 
							 FireTexture'unrealshare.Belt_fx.Invis',
							 true,
							 true);
		if( Inventory != None )
			Inventory.SetOwnerDisplay();
	}

	function ChangedWeapon()
	{
		if ( !bActive )
			return;
		if( Inventory != None )
			Inventory.ChangedWeapon();

		// Make new weapon invisible.
		if ( Pawn(Owner).Weapon != None )
			Pawn(Owner).Weapon.SetDisplayProperties(ERenderStyle.STY_Translucent, 
									 FireTexture'Unrealshare.Belt_fx.Invis',
									 true,
									 true);
	}

	function Timer()
	{
		Charge -= 1;
		Pawn(Owner).Visibility = 10;
		if (Charge<-0)
			UsedUp();
	}

	function BeginState()
	{
		local Inventory S;

		bActive = true;
		PlaySound(ActivateSound,,4.0);

		Owner.SetDisplayProperties(ERenderStyle.STY_Translucent, 
								   FireTexture'unrealshare.Belt_fx.Invis',
								   false,
								   true);
		SetTimer(0.5,True);
		S = Pawn(Owner).FindInventoryType(class'UT_ShieldBelt');
		if ( (S != None) && (UT_Shieldbelt(S).MyEffect != None) )
			UT_Shieldbelt(S).MyEffect.bHidden = true;
	}
}

state DeActivated
{
Begin:
}

defaultproperties
{
     ExpireMessage="Santas cloaking device has worn off."
     PickupMessage="You found Santas cloaking device!"
     ItemName="Santas cloaking device"
     PickupSound=Sound'DanesXmasV3.xmasInvis'
     MultiSkins(1)=Texture'DanesXmasV3.InvisDeco'
}
